<?php
function taxiplon_available_locations () {
    // Available locations
    global $locations;
    $locations = array(
        'airport'   => __('Eleftherios Venizelos Airport', 'taxiplon'),
        'piraeus'	=> __('Piraeus', 'taxiplon'),
        'rafina'    => __('Rafina', 'taxiplon'),
        'lavrio' 	=> __('Lavrio', 'taxiplon'),
        'other'  	=> __('Athens Marriott Hotel', 'taxiplon'),
//    'other-1'  	=> __('Electra Metropolis', 'taxiplon'),
//    'other-2'  	=> __('Electra Palace', 'taxiplon'),
    );
}
add_action( 'init', 'taxiplon_available_locations' );

function taxiplon_enqueue_styles() {
    $parent_style = 'understrap-styles';
    $parent_theme = wp_get_theme("understrap");
    wp_enqueue_style('font-awesome-5', '//use.fontawesome.com/releases/v5.3.1/css/all.css', array( $parent_style ), '5.3.1');
    wp_enqueue_style('pickadate', get_stylesheet_directory_uri() . '/js/pickadate/themes/classic.css', array(  ), '1');
    wp_enqueue_style('pickadate-date', get_stylesheet_directory_uri() . '/js/pickadate/themes/classic.date.css', array() , '1');
    wp_enqueue_style('pickatime', '//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css', array() , '1.3.5');
    wp_enqueue_style('int-tel-number', get_stylesheet_directory_uri() . '/js/int-tel-input/css/intlTelInput.min.css', array() , '1.3.5');

    wp_enqueue_style( 'understrap-styles', get_template_directory_uri() . '/css/theme.min.css', array(), $parent_theme->get( 'Version' ) );
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( $parent_style ),        wp_get_theme()->get('Version')
    );

    wp_enqueue_script( 'pickadate-js', get_stylesheet_directory_uri() . '/js/pickadate/picker.js', array ( 'jquery' ));
    wp_enqueue_script( 'pickadate-date-js', get_stylesheet_directory_uri() . '/js/pickadate/picker.date.js', array ( 'jquery' ));
    wp_enqueue_script( 'pickatime-js', '//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.js', array ( 'jquery' ));
    wp_enqueue_script( 'int-tel-number-js',get_stylesheet_directory_uri() . '/js/int-tel-input/js/intlTelInput.min.js', array ( 'jquery' ));

    // Taxiplon API key
    wp_enqueue_script( 'maps-autocomplete-js', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyAHTXMvQXrsc8VzShInPxvdpaA-AqEyC2o&libraries=places', array ( 'jquery' ));



    wp_enqueue_script( 'taxiplon-js', get_stylesheet_directory_uri() . '/js/taxiplon.js"', array ( 'jquery' ), '1.1.12');

}
add_action( 'wp_enqueue_scripts', 'taxiplon_enqueue_styles' );


//Empty cart before adding new product
add_filter( 'woocommerce_add_to_cart_validation', 'taxiplot_remove_cart_item_before_add_to_cart', 20, 3 );
function taxiplot_remove_cart_item_before_add_to_cart( $passed, $product_id, $quantity ) {
    if( ! WC()->cart->is_empty())
        WC()->cart->empty_cart();
    return $passed;
}

//Add dynamic pricing on taxis
function taxiplon_custom_add_cart_item( $cart_item ) {
    $cart_item['my_price'] = "";

    if (!isset($_GET['price']) || $_GET['price']<2) {
        return $cart_item;
    }

    // Allow only numbers and dot
    $taxi_price = preg_replace('/\D\./', '', $_GET['price']);
    $cart_item['data']->set_price( $taxi_price );
    $cart_item['my_price'] = $taxi_price;

    return $cart_item;
}
add_filter( 'woocommerce_add_cart_item', 'taxiplon_custom_add_cart_item', 5, 1 );

function taxiplon_custom_get_cart_item_from_session( $cart_item, $values ) {

    $cart_item = taxiplon_custom_add_cart_item( $cart_item );
    $cart_item['data']->set_price( $cart_item['price'] );

    return $cart_item;
}
add_filter( 'woocommerce_get_cart_item_from_session', 'taxiplon_custom_get_cart_item_from_session', 5, 2 );


// Allow products with 0 price to be added to cart
function taxiplot_product_is_purchasable( $purchasable, $product ){
    if( $product->get_price() == 0 )
        $purchasable = true;
    return $purchasable;
}
add_filter( 'woocommerce_is_purchasable', 'taxiplot_product_is_purchasable', 10, 2 );


// Add extra trip info to product info in cart
function taxiplon_add_trip_info_to_cart_item( $cart_item_data, $product_id, $variation_id ) {
    $data['pick-up-select']       = sanitize_text_field($_GET['pick-up-select']);
    $data['pick-up-location']     = sanitize_text_field($_GET['pick-up-location']);
    $data['pick-up-post-code']    = sanitize_text_field($_GET['pick-up-post-code']);
    $data['drop-off-select']      = sanitize_text_field($_GET['drop-off-select']);
    $data['drop-off-location']    = sanitize_text_field($_GET['drop-off-location']);
    $data['drop-off-post-code']   = sanitize_text_field($_GET['drop-off-post-code']);
    $data['pick-up-date']         = sanitize_text_field($_GET['pick-up-date']);
    $data['pick-up-time']         = sanitize_text_field($_GET['pick-up-time']);
    $data['pick-up-price']        = sanitize_text_field($_GET['pick-up-price']);
    $data['return-journey']       = sanitize_text_field($_GET['return-journey']);
    $data['passengers']           = sanitize_text_field($_GET['passengers']);
    $data['return-date']          = sanitize_text_field($_GET['return-date']);
    $data['return-time']          = sanitize_text_field($_GET['return-time']);
    $data['return-price']         = sanitize_text_field($_GET['return-price']);
    // $data['post_code']            = sanitize_text_field($_GET['post_code']);
    //$data['from_location']        = sanitize_text_field($_GET['from_location']);
    $data['price']                = sanitize_text_field($_GET['price']);
    $data['luggages']             = sanitize_text_field($_GET['luggages']);
    $data['baby-seats']           = sanitize_text_field($_GET['baby-seats']);



    if ( empty( $data ) ) {
        return $cart_item_data;
    }

    foreach ($data as $key => $value) {
        $cart_item_data[$key] = $value;
    }

    return $cart_item_data;
}

add_filter( 'woocommerce_add_cart_item_data', 'taxiplon_add_trip_info_to_cart_item', 10, 3 );

// Display extra product info in cart
function taxiplon_display_extra_info_text_cart( $item_data, $cart_item ) {
    global $locations;

    if ( empty( $cart_item['pick-up-select'] ) || empty( $cart_item['drop-off-select'] ) ) {
        return $item_data;
    }

    // Display info
    if ($cart_item['return-journey']) {
        $item_data[] = array(
            'key'     => '<i class="fas fa-road"></i> '.__( 'Ride type', 'taxiplon' ),
            'value'   => __( 'Return', 'taxiplon' ),
            'display' => '',
        );
    } else {
        $item_data[] = array(
            'key'     => '<i class="fas fa-road"></i> '.__( 'Ride type', 'taxiplon' ),
            'value'   => __( 'One Way', 'taxiplon' ),
            'display' => '',
        );
    }
    $item_data[] = array(
        'key'     => '<i class="fas fa-map-marked"></i> '.__( 'Pick up address', 'taxiplon' ),
        'value'   => wc_clean( $locations[$cart_item['pick-up-select']] ),
        'display' => '',
    );
    if ($cart_item['pick-up-select']=="other") {
        $item_data[] = array(
            'key'     => '<i class="fas fa-building"></i> '.__( 'Pick up address', 'taxiplon' ),
            'value'   => wc_clean( $cart_item['pick-up-location'] ). ", ".wc_clean( $cart_item['pick-up-post-code'] ),
            'display' => '',
        );
    }
    $item_data[] = array(
        'key'     => '<i class="fas fa-map-marked"></i> '.__( 'Destination', 'taxiplon' ),
        'value'   => wc_clean( $locations[$cart_item['drop-off-select']] ),
        'display' => '',
    );
    if ($cart_item['drop-off-select']=="other") {
        $item_data[] = array(
            'key'     => '<i class="fas fa-building"></i> '.__( 'Destination Address', 'taxiplon' ),
            'value'   => wc_clean( $cart_item['drop-off-location'] ). ", ".wc_clean( $cart_item['drop-off-post-code'] ),
            'display' => '',
        );
    }

    $item_data[] = array(
        'key'     => '<i class="fas fa-calendar-alt"></i> '.__( 'Pick up date and time', 'taxiplon' ),
        'value'   => wc_clean( $cart_item['pick-up-date'])." ".wc_clean( $cart_item['pick-up-time']),
        'display' => '',
    );
    $item_data[] = array(
        'key'     => '<i class="far fa-credit-card"></i> '.__( 'Total fare', 'taxiplon' ),
        'value'   => wc_clean( $cart_item['pick-up-price'])." &euro;",
        'display' => '',
    );
    if ($cart_item['return-journey']) {
        $item_data[] = array(
            'key'     => '<i class="fas fa-calendar-alt"></i> '.__( 'Return date and time', 'taxiplon' ),
            'value'   => wc_clean( $cart_item['return-date'])." ".wc_clean( $cart_item['return-time']),
            'display' => '',
        );
    }
    if ($cart_item['return-price']>0){
        $item_data[] = array(
            'key'     => '<i class="far fa-credit-card"></i> '.__( 'Return fare', 'taxiplon' ),
            'value'   => wc_clean( $cart_item['return-price'])." &euro;",
            'display' => '',
        );
    }


    $item_data[] = array(
        'key'     => '<i class="fas fa-users"></i> '.__( 'Passengers', 'taxiplon' ),
        'value'   => wc_clean( $cart_item['passengers']),
        'display' => '',
    );

    $item_data[] = array(
        'key'     => '<i class="fas fa-suitcase"></i> '.__( 'Standard size luggage', 'taxiplon' ),
        'value'   => wc_clean( $cart_item['luggages']),
        'display' => '',
    );

    if ($cart_item['baby-seats']>=1) {
        if ($cart_item['return-journey']) {
            $double = 2;
        }  else {$double= 1;}
        $baby_seats_cost = " (+".($cart_item['baby-seats'] * 5 * $double)." &euro;)";
    } else {$baby_seats_cost = "";}
    $item_data[] = array(
        'key'     => '<i class="fas fa-child"></i> '.__( 'Baby seats', 'taxiplon' ),
        'value'   => wc_clean( $cart_item['baby-seats']).$baby_seats_cost,
        'display' => '',
    );



    return $item_data;
}

add_filter( 'woocommerce_get_item_data', 'taxiplon_display_extra_info_text_cart', 10, 2 );

// Add extra info to order
function taxiplon_extra_text_to_order_items( $item, $cart_item_key, $values, $order ) {
    global $locations;

    if ( empty( $values['pick-up-select'] ) || empty( $values['drop-off-select'] ) ) {
        return $item_data;
    }

    // Display info
    if ($values['return-journey']) {
        $item->add_meta_data( __( 'Journey type', 'taxiplon' ), __( 'Return', 'taxiplon' ) );
    } else {
        $item->add_meta_data( __( 'Journey type', 'taxiplon' ), __( 'One Way', 'taxiplon' ) );
    }
    $item->add_meta_data( __( 'Pick up location', 'taxiplon' ), wc_clean( $locations[$values['pick-up-select']] ));

    if ($values['pick-up-select']=="other") {
        $item->add_meta_data( __( 'Pick up address', 'taxiplon' ), wc_clean( $values['pick-up-location'] ). ", ".wc_clean( $values['pick-up-post-code'] ));

    }
    $item->add_meta_data( __( 'Drop off location', 'taxiplon' ), wc_clean( $locations[$values['drop-off-select']] ));

    if ($values['drop-off-select']=="other") {
        $item->add_meta_data( __( 'Drop off address', 'taxiplon' ),  wc_clean( $values['drop-off-location'] ). ", ".wc_clean( $values['drop-off-post-code'] ));
    }
    $item->add_meta_data( __( 'Pick up date and time', 'taxiplon' ), wc_clean( $values['pick-up-date'])." ".wc_clean( $values['pick-up-time']));

    if ($values['return-journey']) {
        $item->add_meta_data( __( 'Return date and time', 'taxiplon' ), wc_clean( $values['return-date'])." ".wc_clean( $values['return-time']));
    }
    $item->add_meta_data( __( 'Trip price', 'taxiplon' ), wc_clean( $values['pick-up-price']));
    $item->add_meta_data( __( 'Return trip price', 'taxiplon' ), wc_clean( $values['return-price']));
    $item->add_meta_data( __( 'Passengers', 'taxiplon' ), wc_clean( $values['passengers']));

    $item->add_meta_data( __( 'Luggages', 'taxiplon' ), wc_clean( $values['luggages']));

    $item->add_meta_data( __( 'Baby seats', 'taxiplon' ), wc_clean( $values['baby-seats']));
}

add_action( 'woocommerce_checkout_create_order_line_item', 'taxiplon_extra_text_to_order_items', 10, 4 );


// Custom checkout fields
// Hook in
add_filter( 'woocommerce_checkout_fields' , 'taxiplon_custom_override_checkout_fields' );

function taxiplon_custom_override_checkout_fields( $fields ) {
    $fields['billing']['title']= array(
        'label' => __('Title', 'woocommerce'), // Add custom field label
        'required' => true, // if field is required or not
        'clear' => true, // add clear or not
        'type' => 'select', // add field type
        'options' => array(
            'mr' => "Mr",
            'mrs'=> "Mrs",
            'dr' => 'Dr'
        ),
        'class' => array("form-row-wide","client-title")
    );

    $fields['billing']['on_ship']= array(
        'label' => __('I am traveling by ship', 'woocommerce'), // Add custom field label
        'clear' => true, // add clear or not
        'type' => 'checkbox', // add field type
        'id'    => 'arriving_on_ship',
        'class' => array("form-row tp-toggle"),
        'required'  => false,
    );

    $fields['billing']['on_ship_name']= array(
        'label'     => __('Ship\'s name', 'woocommerce'),
        'placeholder' => __('Please type the ship\'s name', 'woocommerce'), // Add custom field label
        'id'    => 'ship_name_text',
        'required' => true, // if field is required or not
        'clear' => true, // add clear or not
        'type' => 'text', // add field type
        'default' => '0',
        'class' => array("form-row-wide","hidden")
    );

    $fields['billing']['by_air']= array(
        'label' => __('I am traveling by airplane', 'woocommerce'), // Add custom field label
        'clear' => true, // add clear or not
        'type' => 'checkbox', // add field type
        'id'    => 'arriving_by_air',
        'class' => array("form-row tp-toggle"),
        'required'  => false,
    );

    $fields['billing']['by_air_name']= array(
        'label'     => __('Flight\'s number', 'woocommerce'),
        'placeholder' => __('Please type your flight\'s number', 'woocommerce'), // Add custom field label
        'id'    => 'by_air_name_text',
        'required' => true, // if field is required or not
        'clear' => true, // add clear or not
        'type' => 'text', // add field type
        'default' => '0',
        'class' => array("form-row-wide","hidden")
    );

    $fields['billing']['by_air']= array(
        'label' => __('I am arriving on an airplane', 'woocommerce'), // Add custom field label
        'clear' => true, // add clear or not
        'type' => 'checkbox', // add field type
        'id'    => 'arriving_by_air',
        'class' => array("form-row tp-toggle"),
        'required'  => false,
    );



    $fields['order']['order_comments']= array(
        'label' => __('Want to message your driver?', 'woocommerce'),
        'type' => 'textarea',
        'class' => array('notes'),
        'placeholder' => _x('Please type your comments.', 'placeholder', 'woocommerce')
    );

    $fields['order']['newsletter']= array(
        'label' => __('Do you agree to accept emails from us regarding your booking?', 'woocommerce'),
        'clear' => true,
        'type' => 'checkbox',
        'id'    => 'privacy_newsletter',
        'class' => array("form-row tp-toggle"),
        'required'  => true,
    );

    // Remove fields
    unset($fields['billing']['billing_company']);
    unset($fields['billing']['billing_country']);
    unset($fields['billing']['billing_address_1']);
    unset($fields['billing']['billing_address_2']);
    unset($fields['billing']['billing_city']);
    unset($fields['billing']['billing_state']);
    unset($fields['billing']['billing_postcode']);

    // Rerder fields
    $order = array(
        "title",
        "billing_first_name",
        "billing_last_name",
        "billing_email",
        "billing_phone",
        "on_ship",
        "on_ship_name",
        "by_air",
        "by_air_name",
    );
    foreach($order as $field) {
        $ordered_fields[$field] = $fields["billing"][$field];
    }

    $fields["billing"] = $ordered_fields;


    // Placeholders
    $fields['billing']['billing_phone']['placeholder'] = '+30ΧΧΧΧΧΧΧΧΧX';

    return $fields;
}


/**
 * Update the order meta with field value
 */
add_action( 'woocommerce_checkout_update_order_meta', 'texiplon_checkout_field_update_order_meta' );

function texiplon_checkout_field_update_order_meta( $order_id ) {
    if ( ! empty( $_POST['by_air_name'] ) && $_POST['by_air_name'] != '0' ) {
        update_post_meta( $order_id, 'by_air_name', sanitize_text_field( $_POST['by_air_name'] ) );
    }
    if ( ! empty( $_POST['on_ship_name'] ) && $_POST['on_ship_name'] != '0' ) {
        update_post_meta( $order_id, 'on_ship_name', sanitize_text_field( $_POST['on_ship_name'] ) );
    }
    if ( ! empty( $_POST['order_comments'] ) ) {
        update_post_meta( $order_id, 'order_comments', sanitize_text_field( $_POST['order_comments'] ) );
    }
}

// // Redirect add to cart to checkout
add_filter('woocommerce_add_to_cart_redirect', 'themeprefix_add_to_cart_redirect');
function themeprefix_add_to_cart_redirect() {
    global $woocommerce;
    $checkout_url = wc_get_checkout_url();
    return $checkout_url;
}

// Remove xxx has been added to your cart message
add_filter( 'wc_add_to_cart_message_html', '__return_null' );


// Create form shortcode
function taxiplon_taxi_search_form_shortcode() {
    ob_start();
    get_template_part('templates/search-form', 'page' );
    return ob_get_clean();
}
add_shortcode( 'taxi_search_form', 'taxiplon_taxi_search_form_shortcode' );


// WPML switch language button
function taxiplon_languages_switch(){
    $languages = icl_get_languages('skip_missing=0');

    if(1 < count($languages)){
        foreach($languages as $l){
            if(!$l['active']){
                $langs[] = '<span class="'.sanitize_key( $l['translated_name'] ).'button"><a href="'.$l['url'].'">
              <img src="'.$l['country_flag_url'].'" alt="'.$l['native_name'].'" /></a></span>';
            }
        }

        echo join(' ', $langs);
    }
}


// Custom header menu
function taxiplon_custom_new_menu() {
    register_nav_menu('taxiplon-custom-menu',__( 'Taxiplon Header Menu' ));
}
add_action( 'init', 'taxiplon_custom_new_menu' );

// API call After payment
function taxiplon_after_payment_api_call ($order_status, $order_id) {
    date_default_timezone_set('Europe/Athens');


    $data_array =  array(
        "grant_type"=> "password",
        "username" => "307777777777",
        "password" => "0f89421233a976bb57d663f382e03223"
    );
    $data = json_encode($data_array);

    // Login
    function taxiplon_api_login($data, $obj_taxi_id){

        if ($obj_taxi_id == 10) {
            $auth_url = TAXIPLON_API_BASE_URL . "oauth/token";
        } else {
            $auth_url = SIXSTARS_API_BASE_URL . "oauth/token";
        }

        $header_data = array(
            'Authorization: '.TAXIPLON_API_KEY,
            'Content-Type: application/json',
            'Cache-Control: no-cache',
        );
        //var_dump($header_data);
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);



        curl_setopt($curl, CURLOPT_URL, $auth_url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header_data);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

        // EXECUTE:
        $result = curl_exec($curl);

        if(!$result){
            $url = site_url('booking-error/')."?book=connection_error";
            wp_redirect( $url );
            return false;
        }
        curl_close($curl);
        $result_data = json_decode($result);

        if ($result_data->expires_in>1){
            return $result_data;
        }
        else {
            return false;
        }
    }

    function getGeolocation($address) {
        if (trim($address)=="") {
            return false;
        }
        $url = "https://maps.google.com/maps/api/geocode/json?address=".urlencode($address)."&key=".GOOGLE_API_KEY;
        $resp_json = file_get_contents($url);
        $response = json_decode($resp_json, true);

        return $response;
    }

    function get_taxi_types($login_data){

        // $header_data = array(
        //     'Authorization: '.$login_data->access_token,
        //     'Content-Type: application/json',
        //     'Cache-Control: no-cache',
        // );
        // $data= array('returnVehTypes' => true);
        // $out_data = json_encode($data);
        //
        //
        // $curl_url = TAXIPLON_API_BASE_URL . "Vehicles/NearBy";
        // $curl = curl_init();
        // curl_setopt($curl, CURLOPT_POST, 1);
        // curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        //
        // // OPTIONS:
        // curl_setopt($curl, CURLOPT_URL, $curl_url);
        // curl_setopt($curl, CURLOPT_HTTPHEADER, $header_data);
        // curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        //
        // // EXECUTE:
        // $result = curl_exec($curl);
        // if(!$result){die("Connection Failure 3");}
        // curl_close($curl);
        // $result_data = json_decode($result);
        // var_dump($result_data->vehicleTypes->vehicleTypes);

        $taxi_types = array(
            0   => 0, // 'Undefined'
            10  => 1, // Standard Taxi
            9   => 2, // 'Executive'
            108 => 4, // 'Limo'
            12  => 8, // 'Mini Van'
            13  => 16 // 'Mini Bus'
        );

        return $taxi_types;
    }




    //echo $order_id;
    $order              = new WC_Order( $order_id );
    $billing['email']   = $order->get_billing_email();
    $full_phone         = $order->get_billing_phone();

    $tel_array = explode("-",$full_phone);

    $billing['country-code'] = str_replace('+', "", $tel_array[0]);
    $billing['telephone']    = $tel_array[1];

    if ($billing['country-code'] ==""){
        $billing['country-code'] = null;
    }

    $billing['customerName']    = "MARRIOTT:[" . $order->get_billing_last_name() ." ".$order->get_billing_first_name() . "]";
    $billing['by_air_name']     = get_post_meta($order_id, 'by_air_name', true);
    $billing['on_ship_name']    = get_post_meta($order_id, 'on_ship_name', true);

    $billing['order_comments']  = get_post_meta($order_id, 'order_comments', true);
    $billing['payment_method']  = get_post_meta( $order->id, '_payment_method', true );



    // API PAYMENT METHOD Codes
    //   'undefined'  => 0,
    //   'cash'	     => 1,
    //   'creditcard' => 2,
    //   'chargebase' => 3,
    //   'voucher'  	 => 4,

    $billing['api_payment_code']  = 0;
    if ($billing['payment_method']== 'cod') {
        $billing['api_payment_code']  = 1;
    }
    elseif ($billing['payment_method']== 'everypay') {
        $billing['api_payment_code']  = 2;
    }

    function taxiplon_api_payment_methods () {
        // Available locations
        global $payment_methods;

    }
    add_action( 'init', 'taxiplon_api_payment_methods' );



    // Get order items
    foreach ($order->get_items() as $item_id => $item_data) {

        // Get an instance of corresponding the WC_Product object
        $product = $item_data->get_product();

        $product_name = $product->get_name(); // Get the product name
        $item_total = $item_data->get_total(); // Get the item line total

        if (ICL_LANGUAGE_CODE == 'en') {
            $item_meta['journey-type']      = wc_get_order_item_meta($item_id, 'Journey type');
            $item_meta['pick-up-location']  = wc_get_order_item_meta($item_id, 'Pick up location');
            $item_meta['pick-up-address']   = wc_get_order_item_meta($item_id, 'Pick up address');
            $item_meta['pick-up-date-time'] = wc_get_order_item_meta($item_id, 'Pick up date and time');
            $item_meta['trip-price']        = wc_get_order_item_meta($item_id, 'Trip price');
            $item_meta['drop-off-location'] = wc_get_order_item_meta($item_id, 'Drop off location');
            $item_meta['drop-off-address']  = wc_get_order_item_meta($item_id, 'Drop off address');
            $item_meta['return-date-time']  = wc_get_order_item_meta($item_id, 'Return date and time');
            $item_meta['return-trip-price'] = wc_get_order_item_meta($item_id, 'Return trip price');
            $item_meta['luggages']          = wc_get_order_item_meta($item_id, 'Luggages');
            $item_meta['baby_seats']        = wc_get_order_item_meta($item_id, 'Baby seats');
            $item_meta['passengers']        = wc_get_order_item_meta($item_id, 'Passengers');
        }
        elseif (ICL_LANGUAGE_CODE == 'el'){
            $item_meta['journey-type']      = wc_get_order_item_meta($item_id, 'Τύπος ταξιδιού');
            $item_meta['pick-up-location']  = wc_get_order_item_meta($item_id, 'Σημείο παραλαβής');
            $item_meta['pick-up-address']   = wc_get_order_item_meta($item_id, 'Διεύθυνση παραλαβής');
            $item_meta['pick-up-date-time'] = wc_get_order_item_meta($item_id, 'Ημερομηνία και ώρα παραλαβής');
            $item_meta['trip-price']        = wc_get_order_item_meta($item_id, 'Κόστος διαδρομής');
            $item_meta['drop-off-location'] = wc_get_order_item_meta($item_id, 'Προορισμός');
            $item_meta['drop-off-address']  = wc_get_order_item_meta($item_id, 'Διεύθυνση προορισμού');
            $item_meta['return-date-time']  = wc_get_order_item_meta($item_id, 'Ημερομηνία και ώρα επιστροφής');
            $item_meta['return-trip-price'] = wc_get_order_item_meta($item_id, 'Κόστος διαδρομής επιστροφής');
            $item_meta['luggages']          = wc_get_order_item_meta($item_id, 'Αποσκευές');
            $item_meta['baby_seats']        = wc_get_order_item_meta($item_id, 'Παιδικά καθίσματα');
            $item_meta['passengers']        = wc_get_order_item_meta($item_id, 'Επιβάτες');
        }

        if ($item_meta['baby_seats']>=1){
            $item_meta['trip-price-final']          = $item_meta['trip-price'] + $item_meta['baby_seats'] * 5;
            $item_meta['return-trip-price-final']   = $item_meta['return-trip-price'] + $item_meta['baby_seats'] * 5;
        }
        else {
            $item_meta['trip-price-final']          = $item_meta['trip-price'];
            $item_meta['return-trip-price-final']   = $item_meta['return-trip-price'];
        }


        $destinations = array(
            'Rafina'    => "Rafina Port",
            'Lavrio'    => "Lavrio Port",
            'Piraeus'   => "Piraeus Port",
            'Eleftherios Venizelos Airport' => "Eleftherios Venizelos Airport",
            'Athens Marriott Hotel' => 'Athens Marriott Hotel',
            'Ραφήνα'    => "Rafina Port",
            'Λαύριο'    => "Lavrio Port",
            'Πειραιάς'   => "Piraeus Port",
            'Ελ. Βενιζέλος' => "Eleftherios Venizelos Airport",

        );
        $item_meta['address']     = $destinations[$item_meta['pick-up-location']];
        if (strlen(trim($item_meta['pick-up-address']))>2){ $item_meta['address'] .= ", ".$item_meta['pick-up-address'];}
        $item_meta['destination'] = $destinations[$item_meta['drop-off-location']];
        if (strlen(trim($item_meta['drop-off-address']))>2){ $item_meta['destination'] .= ", ".$item_meta['drop-off-address'];}

        // Address long, lat
        $resp = getGeolocation($item_meta['address']);
        if($resp['status']=='OK'){
            // get the longtitude and latitude data
            $item_meta['lat'] = $resp['results'][0]['geometry']['location']['lat'];
            $item_meta['long'] = $resp['results'][0]['geometry']['location']['lng'];
        }
        else {
            $item_meta['lat']  = 0;
            $item_meta['long'] = 0;
        }
        // Destination long, lat
        $resp = getGeolocation($item_meta['destination']);
        if($resp['status']=='OK'){
            // get the longtitude and latitude data
            $item_meta['dest_lat'] = $resp['results'][0]['geometry']['location']['lat'];
            $item_meta['dest_long'] = $resp['results'][0]['geometry']['location']['lng'];
        }
        else {
            $item_meta['dest_lat']  = 0;
            $item_meta['dest_long'] = 0;
        }

        // Add One way
        $obj_taxi_id = icl_object_id($product->id, 'product', false, 'en');
        $login_data = taxiplon_api_login($data, $obj_taxi_id);


        $taxi_types = get_taxi_types($login_data);

        // Check if successful login
        if (!$login_data) {
            wc_add_notice('Error contacting Booking engine, please give us a call.', 'Taxiplon');
            wp_redirect(wc_get_checkout_url()."?api=con-error");
            return 'failed';
        }

        //var_dump(strtotime(str_replace('/','-',$item_meta['pick-up-date-time'])));
        //exit;
        $comments = "";
        if ($item_meta['baby_seats']>=1){
            $comments .= 'Baby Seats: '.$item_meta['baby_seats'].", ";
        }
        if ($item_meta['luggages']>=1){
            $comments .= 'Luggages: '.$item_meta['luggages'].", ";
        }
        if (strlen($billing['by_air_name'])>=1){
            $comments .= 'Flight number: '.$billing['by_air_name'].", ";
        }
        if (strlen($billing['on_ship_name'])>=1){
            $comments .= 'Ship name: '.$billing['on_ship_name'].", ";
        }
        if (strlen($billing['order_comments'])>=1){
            $comments .= 'Order Notes: '.$billing['order_comments'].", ";
        }

        if ($obj_taxi_id == 10) {
            $customerID = 533898;
        } else {
            $customerID = 149;
        }


        $tripdata = array(
            'callTimeStamp' => strtotime(str_replace('/','-',$item_meta['pick-up-date-time'])),
            'callerPhone'   => $billing['telephone'],
            'countryCode'   => $billing['country-code'],
            'roadName'      => $item_meta['address'],
            'comments'      => $comments,
            'longitude'     => $item_meta['long'],
            'latitude'      => $item_meta['lat'],
            'vehType'       => $taxi_types[$obj_taxi_id],
            'taxisNo'       => 1,
            'destination'   => $item_meta['destination'],
            'customerName'  => $billing['customerName'],
            'customerID'    => $customerID,
            'destLongitude' => $item_meta['dest_long'],
            'destLatitude'  => $item_meta['dest_lat'],
            'passengersNo'  => $item_meta['passengers'],
            'dev'           => 'exis',
            'callType'      => 0,
            'costFinal'     => $item_meta['trip-price-final'],
            'costEstimated' => $item_meta['trip-price-final'],
            'paymentMethod' => $billing['api_payment_code'],

        );
        // var_dump($tripdata);
        // exit;
        if ($obj_taxi_id == 10) {
            $curl_base_url = TAXIPLON_API_BASE_URL ;
        } else {
            $curl_base_url = SIXSTARS_API_BASE_URL ;
        }
        $curl_url = $curl_base_url . "calls/register";

        $header_data = array(
            'Authorization: '.$login_data->access_token,
            'Content-Type: application/json',
            'Cache-Control: no-cache',
        );

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($tripdata));

        // OPTIONS:
        curl_setopt($curl, CURLOPT_URL, $curl_url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header_data);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

        // EXECUTE:
        $result = curl_exec($curl);
        // if(!$result){die("Connection Failure 2");}
        curl_close($curl);
        $data = json_decode($result);

        if ($data->response->id > 1){
            woocommerce_add_order_item_meta($item_id, 'Reservation ID', $data->response->id );
            // var_dump($tripdata);
            // var_dump($data);
        }
        else {
            $url = site_url('booking-error/')."?book=reservation_error_2";
            wp_redirect( $url );
            return 'failed';
        }

        //If return add 2nd trip as well
        if ($item_meta['journey-type']=='Return' || $item_meta['journey-type']=='Επιστροφή') {

            $tripdata = array(
                'callTimeStamp' => strtotime(str_replace('/','-',$item_meta['return-date-time'])),
                'callerPhone'   => $billing['telephone'],
                'countryCode'   => $billing['country-code'],
                'roadName'      => $item_meta['destination'],
                'comments'      => $comments,
                'longitude'     => $item_meta['dest_long'],
                'latitude'      => $item_meta['dest_lat'],
                'vehType'       => $taxi_types[$obj_taxi_id],
                'taxisNo'       => 1,
                'destination'   => $item_meta['address'],
                'customerName'  => $billing['customerName'],
                'customerID'    => $customerID,
                'destLongitude' => $item_meta['long'],
                'destLatitude'  => $item_meta['lat'],
                'passengersNo'  => $item_meta['passengers'],
                'dev'           => 'exis',
                'callType'      => 0,
                'costFinal'     => $item_meta['return-trip-price-final'],
                'costEstimated' => $item_meta['return-trip-price-final'],
                'paymentMethod' => $billing['api_payment_code']
            );

            $curl = curl_init();
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($tripdata));

            // OPTIONS:
            curl_setopt($curl, CURLOPT_URL, $curl_url);
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header_data);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
            curl_setopt($curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

            // EXECUTE:
            $result = curl_exec($curl);
            // if(!$result){die("Connection Failure 2");}
            curl_close($curl);
            $data = json_decode($result);
            if ($data->response->id >1){
                woocommerce_add_order_item_meta($item_id, 'Reservation ID_2', $data->response->id );
                // var_dump($tripdata);
                // var_dump($data);
                // exit;
            }
            else {
                $url = site_url('booking-error/')."?book=reservation_error_2";
                wp_redirect( $url );
                return 'failed';
            }
        }

        // Displaying this data (to check)
        //echo 'Product name: '.$product_name.' | Quantity: '.$item_quantity.' | Item total: '. number_format( $item_total, 2 );
    }
    //exit;
    return 'completed';
}
add_filter( 'woocommerce_payment_complete_order_status', 'taxiplon_after_payment_api_call', 10, 2 );

//START - send transaction id to Taxiplon API
function taxiplon_send_payment_data($order, $data) {

    if(isset($order->get_changes()["transaction_id"]) && get_post_meta( $order->id, '_payment_method', true ) == 'everypay' && $order->get_transaction_id() != "") {

        $login_creds_array =  array(
            "grant_type"=> "password",
            "username" => "307777777777",
            "password" => "0f89421233a976bb57d663f382e03223"
        );
        $login_creds = json_encode($login_creds_array);

        $login_data = taxiplon_api_login($login_creds, 10);

        $curl_url = TAXIPLON_API_BASE_URL . 'payments/paymentResult';

        $items = $order->get_items();

        $header_data = array(
            'Authorization: '.$login_data->access_token,
            'Content-Type: application/json',
            'Cache-Control: no-cache',
        );

        $paymentData = array(
            'callId' => -1,
            'reservationId' => woocommerce_get_order_item_meta($items[array_keys($items)[0]]->get_id(), 'Reservation ID', true),
            'transactionID' => $order->get_transaction_id(),
            'orderID' => $order->id,
            'paymentType' => 6,
            'succeeded' => true,
            'amount' => $order->order_total,
            'commission' => getEveryPayCommission($order->get_transaction_id())
        );

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($paymentData));

        // OPTIONS:
        curl_setopt($curl, CURLOPT_URL, $curl_url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header_data);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);

        // EXECUTE:
        $result = curl_exec($curl);
        curl_close($curl);
        $data = json_decode($result);
        if ($data->result->result == "SUCCESS"){
            $order->add_order_note( __( 'Successfully send payment to Taxiplon API', 'woocommerce' ));
        }
        else {
            $logger = wc_get_logger();
            $logger->error(
                sprintf( 'Error completing payment for order #%d', $order->get_id() ), array(
                    'order' => $order,
                    'error' => "Failed to send payment to Taxiplon API",
                )
            );
            $order->add_order_note( __( 'Failed to send payment to Taxiplon API', 'woocommerce' ));
        }
    }


}

function getEveryPayCommission($token) {
    $apiKey = Everypay::getApiKey();
    $url = 'https://' . (Everypay::isTestMode() ? 'sandbox-' : '') . 'api.everypay.gr/payments/'.$token;

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_TIMEOUT, 30);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    curl_setopt($curl, CURLOPT_USERPWD, $apiKey . ':');
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($curl);
    $info = curl_getinfo($curl);

    curl_close($curl);

    $data = json_decode($result, true);

    if(curl_error($curl)) {
        return 0;
    }

    return $data['fee_amount'];
}

add_action( 'woocommerce_before_order_object_save', 'taxiplon_send_payment_data', 10, 2);
//END - send transaction id to Taxiplon API

function exis_disable_checkout_ajax(){
    wp_dequeue_script( 'wc-checkout' );
}

// Disable AJAX checkout on localhost only, WARNING: it breaks everypay payments
if ($_SERVER['SERVER_NAME'] == 'localhost') {
    add_action( 'wp_enqueue_scripts', 'exis_disable_checkout_ajax' );
}


add_action('woocommerce_checkout_process', 'taxiplon_is_phone');
function taxiplon_is_phone() {
    $phone_number = $_POST['billing_phone'];
    if (!preg_match('/^([+][0-9]{1,4}[-][0-9]{10,12})$/', trim($phone_number))){
        wc_add_notice( __( 'Your <b>phone number</b> is wrong. The phone number should be in the form of <b>+30-XXXXXXXXXX</b>.' ), 'error' );
    }

}

/* Add to the functions.php file of your theme */

add_filter( 'woocommerce_order_button_text', 'woo_custom_order_button_text' );

function woo_custom_order_button_text() {
    return __( 'Proceed with payment', 'woocommerce' );
}

/*
 * Show core custom fields
 */
add_filter('acf/settings/remove_wp_meta_box', '__return_false');
/**
 *  extra info to emails
 */
function kia_display_email_order_user_meta( $order, $sent_to_admin, $plain_text ) {
    $flightName= get_post_meta($order->get_id(), 'by_air_name', true);
    $shipName= get_post_meta($order->get_id(), 'on_ship_name', true);
    $flightLabel=  __('Flight\'s number','taxiplon');
    $shipLabel=  __('Ship\'s name','taxiplon');
    $numberLabel=  __('Customer Number','taxiplon');
    $emailLabel=  __('Customer Email','taxiplon');
    if(! empty ( $shipName ) && $shipName != '0'){
        echo '<div style="text-align:left; font-family:\'Helvetica Neue\',Helvetica,Roboto,Arial,sans-serif; padding-left:12px">
                        <h3 style="color:#656565; display:block; font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif; font-size:14px; font-weight:bold; line-height:130%; margin:16px 0 8px; text-align:left; text-transform: capitalize !important;">
                            '.$shipLabel.'
                        </h3>
                        <p>'.$shipName.'</p>
                   </div>';
    }

    if(! empty ( $flightName ) && $flightName != '0'){
        echo '<div style="text-align:left; font-family:\'Helvetica Neue\',Helvetica,Roboto,Arial,sans-serif; padding-left:12px">
                        <h3 style="color:#656565; display:block; font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif; font-size:14px; font-weight:bold; line-height:130%; margin:16px 0 8px; text-align:left; text-transform: capitalize !important;">
                                '.$flightLabel.'
                        </h3>
                        <p>'.$flightName.'</p>
                   </div>';
    }

    echo '<div style="text-align:left; font-family:\'Helvetica Neue\',Helvetica,Roboto,Arial,sans-serif; padding-left:12px">
                        <h3 style="color:#656565; display:block; font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif; font-size:14px; font-weight:bold; line-height:130%; margin:16px 0 8px; text-align:left; text-transform: capitalize !important;">
                                 '.$numberLabel.'
                        </h3>
                        <p>'.$order->get_billing_phone().'</p>
                   </div>';
    echo '<div style="text-align:left; font-family:\'Helvetica Neue\',Helvetica,Roboto,Arial,sans-serif; padding-left:12px">
                    <h3 style="color:#656565; display:block; font-family:&quot;Helvetica Neue&quot;,Helvetica,Roboto,Arial,sans-serif; font-size:14px; font-weight:bold; line-height:130%; margin:16px 0 8px; text-align:left; text-transform: capitalize !important;">
                             '.$emailLabel.'
                    </h3>
                    <p>'.$order->get_billing_email().'</p>
                </div>';
}
add_action('woocommerce_email_customer_details', 'kia_display_email_order_user_meta', 30, 3 );


/*Disable Casn on delivery if choose taxi */

add_filter( 'woocommerce_available_payment_gateways', 'unset_gateway_by_product' );

function unset_gateway_by_product( $available_gateways ) {
    global $woocommerce;
    $unset = false;
    $product_ids = array(10,168);
    foreach ( $woocommerce->cart->cart_contents as $key => $values ) {
        if ( in_array( $values['product_id'], $product_ids )) {
            $unset = true;
            break;
        }
    }
    if ( $unset == true ) unset( $available_gateways['cod'] );
    return $available_gateways;
}

// Send new orders to second email recipient based on Electra hotel chosen.
add_filter( 'woocommerce_email_recipient_customer_processing_order', 'taxiplon_email_hotel_filter_function', 10, 2);

function taxiplon_email_hotel_filter_function($recipient, $order) {
    // Get order items
    foreach ($order->get_items() as $item_id => $item_data) {

        // Get an instance of corresponding the WC_Product object
        $product = $item_data->get_product();

        $product_name = $product->get_name(); // Get the product name
        $item_total = $item_data->get_total(); // Get the item line total

        if (ICL_LANGUAGE_CODE == 'en') {
            $item_meta['pick-up-location']  = wc_get_order_item_meta($item_id, 'Pick up location');
            $item_meta['drop-off-location'] = wc_get_order_item_meta($item_id, 'Drop off location');
        }
        elseif (ICL_LANGUAGE_CODE == 'el'){
            $item_meta['pick-up-location']  = wc_get_order_item_meta($item_id, 'Σημείο παραλαβής');
            $item_meta['drop-off-location'] = wc_get_order_item_meta($item_id, 'Προορισμός');
        }
    }

    $second_email = "";
    if ($item_meta['pick-up-location'] == 'Athens Marriott Hotel' || $item_meta['drop-off-location'] == 'Athens Marriott Hotel') {
        $second_email = 'frontdesk@marriottathens.com';
    }
    elseif ($item_meta['pick-up-location'] == 'Electra Metropolis' || $item_meta['drop-off-location'] == 'Electra Metropolis') {
        $second_email = 'todo@todo.gr';
    }
    elseif ($item_meta['pick-up-location'] == 'Electra Palace' || $item_meta['drop-off-location'] == 'Electra Palace') {
        $second_email = 'todo@todo.gr';
    }

    if ($second_email!="") {
        $recipient = $recipient . ', '.$second_email;
    }

    return $recipient;
}
?>
